<?php


function _getMarketById($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Supplier select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getMarketById(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Supplier Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Supplier Details";
    }

    $response["Supplier"] = $cData;
    header('Content-Type: application/json');
    echo '{"markets":' .json_encode($rData).'}';


}


function _getMarketRecs($mData)
{
    include ('../pdocon.php');
    $numrecs = $mData["numrecs"];
    
    $cData = array();
    $message = "Pending Supplier select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getMarketRecs(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $numrecs, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Supplier Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Supplier Details";
    }

    $response["Supplier"] = $cData;
    header('Content-Type: application/json');
    echo '{"markets":' .json_encode($rData).'}';


}



function _insertMarket($cData)
{
    include ('../pdocon.php');
    
    $havewant = $cData["havewant"];
    $company = $cData["company"];
    $product = $cData["product"];
    $prefdate = $cData["prefdate"];
   
    $message = "Pending market create";
    $status = 0;    
  

    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL insertMarket(?,?,?,?,@success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql); 
        $stmt->bindParam(1, $havewant, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->bindParam(3, $product, PDO::PARAM_STR);
        $stmt->bindParam(4, $prefdate, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Market ad ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _deleteMarket($cData)
{
    include ('../pdocon.php');
    
    $id = $cData["id"];
    $company = $cData["company"];
     
    $message = "Pending market delete";
    $status = 0;    
  

    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL deleteMarket(?,?,@success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql); 
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Market ad ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error deleting market request";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}





?>

