<?php


function _getCompany($cData)
{
    include ('../pdocon.php');
    $id = $cData["id"];
    //print_r($cData);
    $cData = array();
    $message = "Pending client select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getCompany(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Client Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Client Details";
    }

    $response["clients"] = $cData;
    header('Content-Type: application/json');
    echo '{"company":' .json_encode($cData).'}';


}


function _getCompActivities($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    //print_r($cData);
    $cData = array();
    $message = "Pending client select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getCompActivities(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Client Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Client Details";
    }

    $response["clients"] = $cData;
    header('Content-Type: application/json');
    echo '{"compacts":' .json_encode($cData).'}';


}



function _updateCompanyActivity($cData)
{
    include ('../pdocon.php');
    $compactid = $cData['compactid'];
    $receiptno = $cData['receiptno'];
    $payplatform = $cData['payplatform'];
    $rData = array();
    $message = "Pending company create";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateCompanyActivity(?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $compactid, PDO::PARAM_STR);
        $stmt->bindParam(2, $receiptno, PDO::PARAM_STR);
        $stmt->bindParam(3, $payplatform, PDO::PARAM_STR);
        $stmt->execute();
         
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;
     
        $stmt->closeCursor();

        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo '{"updatecompact":' .json_encode($rData).'}';

}



function _insertCompany($cData)
{
    include ('../pdocon.php');
    $name = $cData['name'];
    $email = $cData['email'];
    $level = $cData['level'];
    $createIp = $cData['createIp'];
    $createCity = $cData['createCity'];
    $createRegion = $cData['createRegion'];
    $createCountry = $cData['createCountry'];
    $createOrg = $cData['createOrg'];
    
    
    $rData = array();
    $message = "Pending company create";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertCompany(?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $name, PDO::PARAM_STR);
        $stmt->bindParam(2, $email, PDO::PARAM_STR);
        $stmt->bindParam(3, $level, PDO::PARAM_STR);
        $stmt->bindParam(4, $createIp, PDO::PARAM_STR);
        $stmt->bindParam(5, $createCity, PDO::PARAM_STR);
        $stmt->bindParam(6, $createRegion, PDO::PARAM_STR);
        $stmt->bindParam(7, $createCountry, PDO::PARAM_STR);
        $stmt->bindParam(8, $createOrg, PDO::PARAM_STR);
        $stmt->execute();
         
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;
     
        $stmt->closeCursor();

        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo '{"insertcomp":' .json_encode($rData).'}';

}


function _deleteCompany($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    print_r($cData);
    $cData = array();
    $message = "Pending client select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteCompany(?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

 
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Customer ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Customer Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _updateCompany($cData)
{
   include ('../pdocon.php');
    $id = $cData['id'];
    $name = $cData['name'];
    $level = $cData['level'];
    $email = $cData['email'];
    $logo = $cData['logo'];
    $phone = $cData['phone'];
    $website = $cData['website'];
    $description = $cData['description'];
    $address = $cData['address'];
    $cData = array();
    $message = "Pending client select";
    $status = 0;    
    //print_r($cData);
    /////////////////////////////////////////////////////
    try
    {
        $sql = 'CALL updateCompany(?, ?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $name, PDO::PARAM_STR);
        $stmt->bindParam(3, $level, PDO::PARAM_STR);
        $stmt->bindParam(4, $email, PDO::PARAM_STR);
        $stmt->bindParam(5, $logo, PDO::PARAM_STR);
        $stmt->bindParam(6, $phone, PDO::PARAM_STR);
        $stmt->bindParam(7, $website, PDO::PARAM_STR);
        $stmt->bindParam(8, $description, PDO::PARAM_STR);
        $stmt->bindParam(9, $address, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Customer ".$id. " updated Successfully.";
                $status = 1;
            }

        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);
   
}



?>

