<?php


function _getHazard($hData)
{
    include ('../pdocon.php');
    $id = $hData["id"];
    $company = $hData["company"];
    //print_r($hData);
    //echo "company:", $company;
    $cData = array();
    $message = "Pending hazard select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getHazard(?, ?)';
	//echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
         $stmt->bindParam(1, $id, PDO::PARAM_INT);
         $stmt->bindParam(2, $company, PDO::PARAM_INT);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "hazard Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving hazard Details";
    }

    $response["hazard"] = $cData;
    header('Content-Type: application/json');
    echo '{"hazard":' .json_encode($cData).'}';
}



function _getHazardMeasures($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    //print_r($cData);
    $cData = array();
    $message = "Pending hazard select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getHazardMeasures(?)';
	//echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
         $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "hazard Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving hazard Details";
    }

    $response["hazard"] = $cData;
    header('Content-Type: application/json');
    echo '{"hazardmeasures":' .json_encode($cData).'}';
}



function _insertHazard($cData)
{
    include ('../pdocon.php');
    $type = $cData->type;
    $name = $cData->name;
    $description = $cData->description;
    $step = $cData->stepid;
    $product = $cData->prodid;
    $catbio = $cData->catbio;
    $catphys = $cData->catphys;
    $catchem = $cData->catchem;
    $company = $cData->company;
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertHazard(?,?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $type, PDO::PARAM_STR);
        $stmt->bindParam(2, $name, PDO::PARAM_STR);
        $stmt->bindParam(3, $step, PDO::PARAM_STR);
        $stmt->bindParam(4, $product, PDO::PARAM_STR);
        $stmt->bindParam(5, $description, PDO::PARAM_STR);
        $stmt->bindParam(6, $catbio, PDO::PARAM_STR);
        $stmt->bindParam(7, $catphys, PDO::PARAM_STR);
        $stmt->bindParam(8, $catchem, PDO::PARAM_STR);
        $stmt->bindParam(9, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Hazard ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _insertHazardFromStep($cData)
{
    include ('../pdocon.php');
    $hid = $cData->hid;
    $prodId = $cData->prodId;
    $version = $cData->version;
    $batch = $cData->batchId;
    $step = $cData->stepId;
    $hazardName = $cData->hazardName;
    $hazardType = $cData->hazardType;
    
    $forStep = $cData->forStep;
    $company = $cData->company;
    $message = "Pending client select";
    $status = 0;    
    print_r($cData);
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertHazardFromStep(?,?,?,?,?,?,?,?,?,@success)';
        echo $hid,",",$prodId,",",$stepId,",",$hazardName;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $hid, PDO::PARAM_STR);
        $stmt->bindParam(2, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(3, $version, PDO::PARAM_STR);
        $stmt->bindParam(4, $batch, PDO::PARAM_STR);
        $stmt->bindParam(5, $step, PDO::PARAM_STR);
        $stmt->bindParam(6, $hazardName, PDO::PARAM_STR);
        $stmt->bindParam(7, $hazardType, PDO::PARAM_STR);
        $stmt->bindParam(8, $forStep, PDO::PARAM_STR);
        $stmt->bindParam(9, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
              {
                $message = "Hazard ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    //echo json_encode($actResponse);
    echo '{"hazards":' .json_encode($actResponse).'}';

}





function _insertMeasureFromStep($cData)
{
    include ('../pdocon.php');
    $prodId = $cData->prodId;

    $version = $cData->version;
    $batch = $cData->batchId;
    $step = $cData->stepId;
    $measureName = $cData->measureName;
    $hazardId = $cData->hazardId;

    $hazardName = $cData->hazardName;
    $measureId = $cData->measureId;    
    $company = $cData->company;    
    //$cData = array();

    $message = "Pending insert measure from step";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertMeasureFromStep(?,?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->bindParam(4, $step, PDO::PARAM_STR);
        $stmt->bindParam(5, $measureName, PDO::PARAM_STR);
        $stmt->bindParam(6, $hazardId, PDO::PARAM_STR);
        $stmt->bindParam(7, $hazardName, PDO::PARAM_STR);
        $stmt->bindParam(8, $measureId, PDO::PARAM_STR);
        $stmt->bindParam(9, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Hazard ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    //echo json_encode($actResponse);
    echo '{"hazards":' .json_encode($actResponse).'}';
    
}



function _deleteHazard($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    print_r($cData);
    $cData = array();
    $message = "Pending hazard select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteHazard(?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Hazard ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Customer Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _updateHazard($cData)
{
    include ('../pdocon.php');
    $id = $cData->id;
    $type = $cData->type;
    $name = $cData->name;
    $description = $cData->description;
    $justification = $cData->control;
    
    $step = $cData->step;
    $prodid = $cData->prodid;
    $catbio = $cData->bio;
    $catphys = $cData->phys;
    $catchem = $cData->chem;
    $company = $cData->company;
    $message = "Pending client select";
    $status = 0;   
    echo "cdata is";
    echo $id,",",$name,",",$catbio;
    print_r($cData);
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateHazard(?, ?,?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $type, PDO::PARAM_STR);
        $stmt->bindParam(3, $name, PDO::PARAM_STR);
        $stmt->bindParam(4, $step, PDO::PARAM_STR);
        $stmt->bindParam(5, $product, PDO::PARAM_STR);    
        $stmt->bindParam(6, $description, PDO::PARAM_STR);       
        $stmt->bindParam(7, $catbio, PDO::PARAM_STR);
        $stmt->bindParam(8, $catphys, PDO::PARAM_STR);
        $stmt->bindParam(9, $catchem, PDO::PARAM_STR);
        $stmt->bindParam(10, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Hazard ".$id. " updated Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



?>

