<?php


function _getIngredient($idata)
{
    include ('../pdocon.php');
    $id = $idata["id"];
    $company = $idata["company"];
    print_r($cData);
    $cData = array();
    $message = "Pending Ingredient select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getIngredients(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Ingredient Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Ingredient Details";
    }

    $response["Ingredient"] = $cData;
    header('Content-Type: application/json');
    echo '{"ingredients":' .json_encode($cData).'}';

}


function _getIngredsForStep($iData)
{
    include ('../pdocon.php');

    $cData = array();
    $message = "Pending Ingredient select";
    $status = 0; 
    $prodid = $iData["prodid"];   
    $stepid = $iData["stepid"];   
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStepIngredients(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $stepid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Ingredient Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Ingredient Details";
    }

    $response["Ingredient"] = $cData;
    header('Content-Type: application/json');
    echo '{"stepingredients":' .json_encode($cData).'}';

}


function _getIngredsForProduct($iData)
{
    include ('../pdocon.php');

    $cData = array();
    $message = "Pending Ingredient select";
    $status = 0; 
    $prodid = $iData["prodid"];   
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdIngredients(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Ingredient Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Ingredient Details";
    }

    $response["Ingredient"] = $cData;
    header('Content-Type: application/json');
    echo '{"prodingredients":' .json_encode($cData).'}';

}


function _getProdsWithIngred($iData)
{
    include ('../pdocon.php');

    $cData = array();
    $message = "Pending Ingredient select";
    $status = 0; 
    $iid = $iData["iid"];   
     /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getIngredientProducts(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $iid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Ingredient Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Ingredient Details";
    }

    $response["ingredientproducts"] = $cData;
    header('Content-Type: application/json');
    echo '{"ingredientproducts":' .json_encode($cData).'}';

}

function _getMovements($iData)
{
    include ('../pdocon.php');

    $cData = array();
    $message = "Pending Ingredient select";
    $status = 0; 
    $iid = $iData["iid"];   
   
     /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getInventoryMovements(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $iid, PDO::PARAM_STR);
        
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Ingredient Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Ingredient Details";
    }

    $response["ingredientmovements"] = $cData;
    header('Content-Type: application/json');
    echo '{"inventorymovements":' .json_encode($cData).'}';

}



function _insertIngredient($cData)
{
    include ('../pdocon.php');
    $name = $cData->name;
    $qtyStock = $cData->qtystock;
    $unit = $cData->units;
    $minqty = $cData->minQty;
    $allergen = $cData->allergen;
    $company = $cData->company;
    if ($minqty=='')
       $minqty=0;
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertIngredient(?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $name, PDO::PARAM_STR);
        $stmt->bindParam(2, $qtyStock, PDO::PARAM_STR);
        $stmt->bindParam(3, $unit, PDO::PARAM_STR);
        $stmt->bindParam(4, $minqty, PDO::PARAM_STR);
        $stmt->bindParam(5, $allergen, PDO::PARAM_STR);
        $stmt->bindParam(6, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}




function _remIngredFromProduct($iData)
{
    echo ("started rem");
    print_r($iData);
    include ('../pdocon.php');
    $prodid = $iData["pid"];
    $iid = $iData["iid"];
    //echo $prodid,",",$ingredid,",",$selstep;
    $cData = array();
    $message = "Pending ingred remove";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL removeIngredFromProd(?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $iid, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Storage ".$row['Success']. " added Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _addToProduct($iData)
{
    include ('../pdocon.php');
    $prodid = $iData["prodid"];
    $ingredid = $iData["ingredid"];
    $selstep = $iData["selstep"];
    $company = $iData["company"];
    $qty = $iData["qty"];
    //print_r($iData);
    //echo $prodid,",",$ingredid,",",$selstep;
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertIngredToProd(?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $ingredid, PDO::PARAM_STR);
        $stmt->bindParam(3, $selstep, PDO::PARAM_STR);
        $stmt->bindParam(4, $qty, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _moveInventory($cData)
{
    include ('../pdocon.php');
    $direction = $cData['direction'];
    $prodid = $cData['prodId'];
    $version = $cData['version'];
    $batchid = $cData['batchId'];
    $stepid = $cData['stepId'];
    $qty = $cData['qty'];
    $ingredid = $cData['ingredId'];
    $company = $cData['company'];
    
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {
        $sql = 'CALL moveInventory(?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $direction, PDO::PARAM_STR);
        $stmt->bindParam(2, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(3, $version, PDO::PARAM_STR);
        $stmt->bindParam(4, $batchid, PDO::PARAM_STR);
        $stmt->bindParam(5, $stepid, PDO::PARAM_STR);
        $stmt->bindParam(6, $qty, PDO::PARAM_STR);
        $stmt->bindParam(7, $ingredid, PDO::PARAM_STR);
        $stmt->bindParam(8, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _increaseInventory($cData)
{
    include ('../pdocon.php');
    print_r($cData);
     $qty = $cData['qty'];
     $ingredId = $cData['ingredId'];
     $storebin = $cData['storebin'];
     $expDate = $cData['expDate'];
     $notes = $cData['notes'];
     $domain = $cData['domain'];
     $company = $cData['company'];
     $product = $cData['product'];
     $batch = $cData['batch'];
     $linked = $cData['linked'];
     $outcompany = $cData['outcompany'];
     
     if ($batch=='')
       $batch=0;
  
     $cData = array();
     $message = "Pending client select";
     $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL increaseInventory(?,?,?,?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $qty, PDO::PARAM_STR);
        $stmt->bindParam(2, $ingredId, PDO::PARAM_STR);
        $stmt->bindParam(3, $storebin, PDO::PARAM_STR);
        $stmt->bindParam(4, $expDate, PDO::PARAM_STR);
        $stmt->bindParam(5, $notes, PDO::PARAM_STR);
        $stmt->bindParam(6, $domain, PDO::PARAM_STR);
        $stmt->bindParam(7, $company, PDO::PARAM_STR);
        $stmt->bindParam(8, $product, PDO::PARAM_STR);
        $stmt->bindParam(9, $batch, PDO::PARAM_STR);
        $stmt->bindParam(10, $linked, PDO::PARAM_STR);
        $stmt->bindParam(11, $outcompany, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _decreaseInventory($cData)
{
    include ('../pdocon.php');
     $qty = $cData['qty'];
     $ingredId = $cData['ingredId'];
     $storebin = $cData['storebin'];
     $notes = $cData['notes'];
      
     $cData = array();
     $message = "Pending client select";
     $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL decreaseInventory(?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $qty, PDO::PARAM_STR);
        $stmt->bindParam(2, $ingredId, PDO::PARAM_STR);
        $stmt->bindParam(3, $storebin, PDO::PARAM_STR);
        $stmt->bindParam(4, $notes, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}





function _deleteIngredient($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    print_r($cData);
    $cData = array();
    $message = "Pending Ingredient delete";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteIngredient(?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Customer Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _updateIngredient($cData)
{
    include ('../pdocon.php');
    print_r($cData);
        
    $id = $cData["id"];
    $name = $cData["name"];

    $qtyStock = $cData["qtystock"];
    $unit = $cData["units"];
    $minqty = $cData["minQty"];
    $allergen = $cData["allergen"];
    $sourcecompany = $cData["sourcecompany"];
    $product = $cData["product"];
    $message = "Pending Ingredient update";
    
    $status = 0; 
     echo $id ,',',$name ,',',$qtyStock,',',$unit ,',',$minqty,',',$allergen ;
  
    print_r($cData);
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateIngredient(?, ?,?, ?,?, ?,?, ?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $name, PDO::PARAM_STR);
        $stmt->bindParam(3, $qtyStock, PDO::PARAM_STR);
        $stmt->bindParam(4, $unit, PDO::PARAM_STR);
        $stmt->bindParam(5, $minqty, PDO::PARAM_STR);
        $stmt->bindParam(6, $allergen, PDO::PARAM_STR);
        $stmt->bindParam(7, $sourcecompany, PDO::PARAM_STR);
        $stmt->bindParam(8, $product, PDO::PARAM_STR);
        $stmt->execute();

        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);

        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Ingredient ".$id. " updated Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}




?>

