<?php


function _getMeasure($mdata)
{
    include ('../pdocon.php');
    $id = $mdata["id"];
    $company = $mdata["company"];
    //print_r($cData);
    $cData = array();
    $message = "Pending Measure select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getPreventMeasures(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Measure Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Measure Details";
    }

    $response["Measure"] = $cData;
    header('Content-Type: application/json');
    echo '{"measure":' .json_encode($cData).'}';
}


function _getMeasureHazards($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
     //print_r($cData);
    $cData = array();
    $message = "Pending hazard select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getMeasureHazards(?)';
	//echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
         $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "hazard Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving hazard Details";
    }

    $response["measures"] = $cData;
    header('Content-Type: application/json');
    echo '{"measurehazards":' .json_encode($cData).'}';
}


function _insertMeasure($cData)
{
    include ('../pdocon.php');
    $name = $cData['name'];
    $description = $cData['description'];
    $justification = $cData['justification'];
    $hazardId = $cData['hazardId'];
    $company = $cData['company'];
    $message = "Pending client select";
    $status = 0;    
        
    //////////////////////////kkkkkkkkkkkkkkkkkkkkkkkkk/justification//////////////////////////
    try
    {

        $sql = 'CALL insertPreventMeasure(?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $name, PDO::PARAM_STR);
        $stmt->bindParam(2, $description, PDO::PARAM_STR);
        $stmt->bindParam(3, $justification, PDO::PARAM_STR);
        $stmt->bindParam(4, $hazardId, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Measure ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _deleteMeasure($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    print_r($cData);
    $cData = array();
    $message = "Pending Measure delete";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deletePreventMeasure(?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
           
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Measure ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Measure Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _updateMeasure($cData)
{
    include ('../pdocon.php');
    //print_r($cData);
    $id = $cData->id;
    $name = $cData->name;
    $description = $cData->description;
    $justification = $cData->justification;
    $company = $cData->company;
    $message = "Pending Measure update";
    $status = 0; 

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updatePreventMeasure(?, ?,?,?,?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $name, PDO::PARAM_STR);
        $stmt->bindParam(3, $description, PDO::PARAM_STR);
        $stmt->bindParam(4, $justification, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        $stmt->execute();

        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Measure ".$id. " updated Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



?>

