<?php


function _getMessageById($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Supplier select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getMessageById(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Supplier Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Message Details";
    }

    $response["Supplier"] = $cData;
    header('Content-Type: application/json');
    echo '{"message":' .json_encode($cData).'}';


}


function _getMessagesForCompany($mData)
{
    include ('../pdocon.php');
    $company = $mData['company'];
    
    $cData = array();
    $message = "Pending Supplier select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getMessagesForCompany(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Supplier Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Supplier Details";
    }

    $response["Supplier"] = $cData;
    header('Content-Type: application/json');
    echo '{"messages":' .json_encode($cData).'}';


}



function _insertMessage($cData)
{
    include ('../pdocon.php');
    
    $msgFrom = $cData->msgFrom;
    $msgTo = $cData->msgTo;
    $title = $cData->title;
    $body = $cData->body;
   
    $message = "Pending market create";
    $status = 0;    
  
    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL insertMessage(?,?,?,?,@success)';
        //echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql); 
        $stmt->bindParam(1, $msgFrom, PDO::PARAM_STR);
        $stmt->bindParam(2, $msgTo, PDO::PARAM_STR);
        $stmt->bindParam(3, $title, PDO::PARAM_STR);
        $stmt->bindParam(4, $body, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Message ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo '{"messages":' .json_encode($actResponse).'}';

}


function _deleteMessage($cData)
{
    include ('../pdocon.php');
    
    $id = $cData['id'];
    $company = $cData['company'];
     
    $message = "Pending market delete";
    $status = 0;    
  

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteMessage(?,?,@success)';
        //echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql); 
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Market ad ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error deleting market request";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    //echo json_encode($actResponse);
    echo '{"messages":' .json_encode($actResponse).'}';

}





?>

