<?php


function _getStep($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Step select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStep(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        //echo 'id', $id;
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Step Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Step Details";
    }

    $response["Step"] = $cData;
    header('Content-Type: application/json');
    echo '{"steps":' .json_encode($cData).'}';
 

}


function _getStepHazards($data)
{
    include ('../pdocon.php');
    //print_r($data);
    $prodId = $data['prodId'];
    $stepId = $data['stepId'];

    $message = "Pending Step select";
    $status = 0;   
    $cData = array(); 
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStepHazards(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        //echo 'prod,stepid', $prodId, $stepId;
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $stepId, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Step Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Step Details";
    }

    $response["Step"] = $cData;
    header('Content-Type: application/json');
    echo '{"stephazards":' .json_encode($cData).'}';
 

}



function _insertStep($cData)
{
    include ('../pdocon.php');
    $name = $cData->name;
    $part_of = $cData->part_of;
    $predId = $cData->predId;
    $prodId = $cData->prodId;
    $company = $cData->company;
    $showAuth = $cData->showauth;
    $showCust = $cData->showcust;
    if (strlen($part_of)==0){
       $part_of =-1;
       }
    if (strlen($predId)==0){
       $predId =-1;    
       }   
    $message = "Pending Step select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL insertStep(?,?,?,?,?,?,?,@success)';
        //echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $name, PDO::PARAM_STR);
        $stmt->bindParam(2, $part_of, PDO::PARAM_STR);
        $stmt->bindParam(3, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(4, $predId, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        $stmt->bindParam(6, $showAuth, PDO::PARAM_STR);
        $stmt->bindParam(7, $showCust, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Step ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _lockProdBatchStep($cData)
{
    include ('../pdocon.php');

    $prodId = $cData["prodid"];
    $batchId = $cData["batch"];
    $stepId = $cData["step"];
    $lockedBy = $cData["lockedBy"];
    $company = $cData["company"];
    $message = "Pending Step select";
    $status = 0;    
    /////////////////////////////////////////////////////
    //try
   // {

        $sql = 'CALL lockProdBatchStep(?,?,?,?,?,@success)';
      //  echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $batchId, PDO::PARAM_STR);
        $stmt->bindParam(3, $stepId, PDO::PARAM_STR);
        $stmt->bindParam(4, $lockedBy, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        //print_r($cData);    
        //echo $prodId, $batchId, $stepId, $lockedBy, $company;
        
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Step ".$row['Success']. " locked Successfully.";
                $status = 1;
            }
        }
        
   // }
   // catch(PDOException $e)
   // {
   //     echo ("Error occurred:" . $e->getMessage());
   //     $response["status"] = "False";
   //     $response["message"] = "Error creating customer";
   // }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}

function _unlockProdBatchStep($cData)
{
    include ('../pdocon.php');


    $prodId = $cData["prodid"];
    $batchId = $cData["batch"];
    $stepId = $cData["step"];
    $lockedBy = $cData["lockedBy"];
    $company = $cData["company"];
    $message = "Pending Step select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL unlockProdBatchStep(?,?,?,?,?,@success)';
        //echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $batchId, PDO::PARAM_STR);
        $stmt->bindParam(3, $stepId, PDO::PARAM_STR);
        $stmt->bindParam(4, $lockedBy, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Step ".$row['Success']. " unlocked Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _deleteStep($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    print_r($cData);
    $cData = array();
    $message = "Pending Step delete";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteStep(?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
           
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Step ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Measure Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _updateStep($cData)
{
    include ('../pdocon.php');

    $id = $cData->id;
    $name = $cData->name;
    $part_of = $cData->part_of;
    $predId = $cData->predId;
    $prodId = $cData->prodId;
    $company = $cData->company;
    $showAuth = $cData->showauth;
    $showCust = $cData->showcust;

    $message = "Pending Step update";
    $status = 0; 

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateStep(?,?,?,?,?,?,?,?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $name, PDO::PARAM_STR);
        $stmt->bindParam(3, $part_of, PDO::PARAM_STR);
        $stmt->bindParam(4, $predId, PDO::PARAM_STR);
        $stmt->bindParam(5, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(6, $company, PDO::PARAM_STR);
        $stmt->bindParam(7, $showAuth, PDO::PARAM_STR);
        $stmt->bindParam(8, $showCust, PDO::PARAM_STR);

        $stmt->execute();

        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Step ".$id. " updated Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



?>

