<?php


function _getStorage($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Storage select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStorage(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Storage Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Storage Details";
    }

    $response["Storage"] = $cData;
    header('Content-Type: application/json');
    echo '{"storage":' .json_encode($cData).'}';

}


function _getProdStorage($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Storage select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdStoreReq(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Storage Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Storage Details";
    }

    $response["Storage"] = $cData;
    header('Content-Type: application/json');
    echo '{"prodstorage":' .json_encode($cData).'}';

}



function _getStorageCategory($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Storage select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStorageCategory(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Storage Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Storage Details";
    }

    $response["Storage"] = $cData;
    header('Content-Type: application/json');
    echo '{"storagecategory":' .json_encode($cData).'}';
    
   
}

function _getStoresInCategory($cat)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
 
    $cData = array();
    $message = "Pending Storage select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStoresInCategory(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $cat, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Storage Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Storage Details";
    }

    $response["Storage"] = $cData;
    header('Content-Type: application/json');
    echo '{"storesincategory":' .json_encode($cData).'}';
    
   
}

function _getAllStorageCategories()
{
    include ('../pdocon.php');
    //$id = $cData["id"];
 
    $cData = array();
    $message = "Pending Storage select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStorageCategories()';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Storage Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Storage Details";
    }

    $response["Storage"] = $cData;
    header('Content-Type: application/json');
    echo '{"allstores":' .json_encode($cData).'}';
    
   
}



function _getStorageForStep($iData)
{
    include ('../pdocon.php');

    $cData = array();
    $message = "Pending storage select";
    $status = 0; 
    $prodid = $iData["prodid"];   
    $stepid = $iData["stepid"];   
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getStepStorage(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $stepid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Storage Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving storage Details";
    }

    $response["Storage"] = $cData;
    header('Content-Type: application/json');
    echo '{"stepstorage":' .json_encode($cData).'}';

}



function _addStorageToProduct($iData)
{
    include ('../pdocon.php');
    //print_r($iData);
    $prodid = $iData["prodid"];
    $storageid = $iData["storageid"];
    $selstep = $iData["selstep"];
    $company = $iData["company"];

    //echo $prodid,",",$ingredid,",",$selstep;
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertStorageToProd(?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $storageid, PDO::PARAM_STR);
        $stmt->bindParam(3, $selstep, PDO::PARAM_STR);
        $stmt->bindParam(4, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Storage ".$row['Success']. " added Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _remStorageFromProduct($iData)
{
    include ('../pdocon.php');
    print_r($iData);
    $prodid = $iData["pid"];
    $storageid = $iData["sid"];
    //echo $prodid,",",$ingredid,",",$selstep;
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL removeStorageFromProd(?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $storageid, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Storage ".$row['Success']. " added Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _insertProdBatchStepStorage($iData)
{
    include ('../pdocon.php');
    //print_r($iData);

    $prodid = $iData["prodid"];
    $storageid = $iData["storageid"];
    $step = $iData["step"];
    $company = $iData["company"];
    $batch = $iData["batch"];
    $recordedBy = $iData["recordedBy"];
  
    //echo $prodid,",",$ingredid,",",$selstep;
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertProdBatchStorage(?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $batch, PDO::PARAM_STR);
        $stmt->bindParam(3, $step, PDO::PARAM_STR);
        $stmt->bindParam(4, $storageid, PDO::PARAM_STR);
        $stmt->bindParam(5, $recordedBy, PDO::PARAM_STR);
        $stmt->bindParam(6, $company, PDO::PARAM_STR);
       $stmt->execute();
        $stmt->closeCursor();
        // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Storage ".$row['Success']. " added Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _deleteProdBatchStepStorage($iData)
{
    include ('../pdocon.php');

    $prodid = $iData["prodid"];
    $storageid = $iData["storageid"];
    $step = $iData["step"];
    $company = $iData["company"];
    $batch = $iData["batch"];
  
    $cData = array();
    $message = "Pending client select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteProdBatchStorage(?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $batch, PDO::PARAM_STR);
        $stmt->bindParam(3, $step, PDO::PARAM_STR);
        $stmt->bindParam(4, $storageid, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
 
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Storage ".$row['Success']. " added Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _insertStorage($cData)
{
    include ('../pdocon.php');
    $location = $cData->location;
    $capacity = $cData->capacity;
    $remspace = $cData->remspace;
    $spaceunits = $cData->spaceunits;
    $temperature_c = $cData->temperature_c;
    $message = "Pending Storage select";
    $status = 0;    


    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL insertStorage(?,?,?,?,?,@success)';
        //echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql); 
        $stmt->bindParam(1, $location, PDO::PARAM_STR);
        $stmt->bindParam(2, $capacity, PDO::PARAM_STR);
        $stmt->bindParam(3, $remspace, PDO::PARAM_STR);
        $stmt->bindParam(4, $spaceunits, PDO::PARAM_STR);
        $stmt->bindParam(5, $temperature_c, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        //print_r($row);
        if ($row)
        {
            //echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Storage ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _deleteStorage($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    print_r($cData);
    $cData = array();
    $message = "Pending Storage delete";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteStorage(?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
           
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Storage ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Measure Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _updateStorage($cData)
{
    include ('../pdocon.php');
    print_r($cData);
    $id = $cData->id;
    $location = $cData->location;
    $capacity = $cData->capacity;
    $remspace = $cData->remspace;
    $spaceunits = $cData->spaceunits;
    $temperature_c = $cData->temperature_c;
    $message = "Pending Storage update";
    $status = 0; 

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateStorage(?,?,?,?,?,?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $location, PDO::PARAM_STR);
        $stmt->bindParam(3, $capacity, PDO::PARAM_STR);
        $stmt->bindParam(4, $remspace, PDO::PARAM_STR);
        $stmt->bindParam(5, $spaceunits, PDO::PARAM_STR);
        $stmt->bindParam(6, $temperature_c, PDO::PARAM_STR);
        $stmt->execute();

        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Storage ".$id. " updated Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



?>

