<?php
//CREATE TABLE `clients` (
//`  `id` int(11) NOT NULL,
//  `dob` date NOT NULL,
//  `age` int(11) NOT NULL,
//  `email` varchar(70) NOT NULL,
//  `firstname` varchar(20) NOT NULL,
//  `middlename` varchar(20) NOT NULL,
//  `surname` varchar(40) NOT NULL,
//  `gender` int(11) NOT NULL,
//  `homeNo` varchar(20) NOT NULL,
//  `mobileNo` varchar(20) NOT NULL,
//  `parent_guard` varchar(30) NOT NULL,
//  `pref_dob_age` int(11) NOT NULL,
//  `workno` varchar(20) NOT NULL,


function _getUser($uData)
{

    include ('../pdocon.php');
    $id = $uData['id'];
    $company =$uData['company'];
    $cData = array();
    $message = "Pending user select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {
        $sql = 'CALL getUser(?,?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Client Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving Client Details";
    }

    $response["clients"] = $cData;
    header('Content-Type: application/json');
    echo '{"users":' .json_encode($cData).'}';

}



function _signupUser($uData)
{
    include ('../pdocon.php');
    $message = "Pending user insert";
     print($message);
    $status = 0; 
    $uname = $uData["name"];
    $pwd = $uData["pwd"];
    $email = $uData["email"];
    $role = $uData["role"];
    $company = $uData["company"];
    print_r($uData);
    echo  $uname,",",$pwd,",",$email,",",$role;
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertUser(?,?,?,?,?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        // pass value to the command
        $stmt->bindParam(1, $uname, PDO::PARAM_STR);
        $stmt->bindParam(2, $pwd, PDO::PARAM_STR);
        $stmt->bindParam(3, $email, PDO::PARAM_STR);
        $stmt->bindParam(4, $role, PDO::PARAM_STR);
        $stmt->bindParam(5, $company, PDO::PARAM_STR);
        
        // execute the stored procedure
        $stmt->execute();

        $stmt->closeCursor();

        // execute the second query to test whether insert worked
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);

        if ($row)
        {
            if ($row['Success'] == 1)
            {
                $message = "User created Successfully.";
                $status = 1;
            }
        }

    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
    }

    //////////////////////////////////////////////////////////
    $actResponse = array(
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    
}


function _insertLoginFailure($uData)
{
    include ('../pdocon.php');
    $message = "Pending user insert";
     print($message);
    $status = 0; 
    $uid = $uData["uid"];
    $pwd = $uData["pwd"];
    $loginIp = $uData["loginIp"];
    $loginCity = $uData["loginCity"];
    $loginRegion = $uData["loginRegion"];
    $loginCountry = $uData["loginCountry"];
    $loginOrg = $uData["loginOrg"];
    $comment = $uData["comment"];
    print_r($uData);
    echo  $uname,",",$pwd,",",$email,",",$role;
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL insertLoginFailures(?,?,?,?,?,?,?,?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        // pass value to the command
        $stmt->bindParam(1, $uid, PDO::PARAM_STR);
        $stmt->bindParam(2, $pwd, PDO::PARAM_STR);
        $stmt->bindParam(3, $loginIp, PDO::PARAM_STR);
        $stmt->bindParam(4, $loginCity, PDO::PARAM_STR);
        $stmt->bindParam(5, $loginRegion, PDO::PARAM_STR);
        $stmt->bindParam(6, $loginCountry, PDO::PARAM_STR);
        $stmt->bindParam(7, $loginOrg, PDO::PARAM_STR);
        $stmt->bindParam(8, $comment, PDO::PARAM_STR);
        
        // execute the stored procedure
        $stmt->execute();

        $stmt->closeCursor();

        // execute the second query to test whether insert worked
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);

        if ($row)
        {
            if ($row['Success'] == 1)
            {
                $message = "User created Successfully.";
                $status = 1;
            }
        }

    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
    }

    //////////////////////////////////////////////////////////
    $actResponse = array(
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    
}


function _userExists($uData)
{
    include ('../pdocon.php');
    $message = "Pending user insert";
    $status = 0; 
    $uname = $uData["name"];
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL userExists(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        // pass value to the command
        $stmt->bindParam(1, $uname, PDO::PARAM_STR);
          
        // execute the stored procedure
        $stmt->execute();

        $stmt->closeCursor();
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) $rData[] = $row;

        $stmt->closeCursor();
       
        if ($row)
        {
            if ($row['Success'] == 1)
            {
                $message = "User created Successfully.";
                $status = 1;
            }
        }

    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
    }

    //////////////////////////////////////////////////////////
    $actResponse = array(
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo '{"userExists":' .json_encode($rData).'}';
    
}


function _loginUser($uData)
{
    include ('../pdocon.php');
    $message = "Pending user insert";
    $status = 0; 
    $uname = $uData["user"];
    $pwd = $uData["pwd"];
    $loginIp = $uData["loginIp"];
    $rData = array();
   
       /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL loginUser(?,?,?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        // pass value to the command
        $stmt->bindParam(1, $uname, PDO::PARAM_STR);
        $stmt->bindParam(2, $pwd, PDO::PARAM_STR);
        $stmt->bindParam(3, $loginIp, PDO::PARAM_STR);
          
        // execute the stored procedure
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) $rData[] = $row;

        $stmt->closeCursor();

        // execute the second query to test whether insert worked
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);

        if ($row)
        {
            if ($row['Success'] == 1)
            {
                $message = "User logged in Successfully.";
                $status = 1;
            }
        }
   

    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
    }

    
    ////////////////////////////////////////////////////////////
    $actResponse = array(
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    //echo json_encode($rData);
    echo '{"users":' .json_encode($rData).'}';

}

function _updateUser($uData)
{
    include ('../pdocon.php');
    $message = "Pending user update";
     print($message);
    $status = 0; 
    $uid = $uData["id"];
    $uname = $uData["name"];
    $pwd = $uData["pwd"];
    $email = $uData["email"];
    $role = $uData["role"];
       /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateUser(?,?,?,?,?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        // pass value to the command
        $stmt->bindParam(1, $uid, PDO::PARAM_STR);
        $stmt->bindParam(2, $uname, PDO::PARAM_STR);
        $stmt->bindParam(3, $pwd, PDO::PARAM_STR);
        $stmt->bindParam(4, $email, PDO::PARAM_STR);
        $stmt->bindParam(5, $role, PDO::PARAM_STR);
        
        // execute the stored procedure
        $stmt->execute();

        $stmt->closeCursor();

        // execute the second query to test whether insert worked
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);

        if ($row)
        {
            if ($row['Success'] == 1)
            {
                $message = "User updated Successfully.";
                $status = 1;
            }
        }

    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
    }

    //////////////////////////////////////////////////////////
    $actResponse = array(
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    
}

function _deleteUser($cdata)
{
    include ('../pdocon.php');
    $message = "Pending user delete";
    $status = 0; 
    $id = $cdata["id"];
   
    if ($id)
    {

        try
        {

            $sql = 'CALL deleteUser(?,@success)';
            $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
            $stmt = $pdo->prepare($sql);

            // pass value to the command
            $stmt->bindParam(1, $id, PDO::PARAM_INT);

            // execute the stored procedure
            $stmt->execute();

            $stmt->closeCursor();

            // execute the second query to get customer's level
            $row = $pdo->query("SELECT @Success AS Success")
                ->fetch(PDO::FETCH_ASSOC);

            if ($row)
            {
                if ($row['Success'] == 1)
                {
                    $message = "User deleted Successfully.";
                    $status = 1;
                }
            }

        }
        catch(PDOException $e)
        {
            echo ("Error occurred:" . $e->getMessage());
        }

    }
    else
    {
        $message = "Invalid request.";
        $status = 0;
    }

    //////////////////////////////////////////////////////////
    $actResponse = array(
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}


function _getTablesOnline()
{
    include ('../pdocon.php');
    $cData = array();
    $message = "Pending user select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getTablesOnline()';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);

        //$stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "tables online";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retieving tables online";
    }

    $response["clients"] = $cData;
    header('Content-Type: application/json');
    //$mac = system('arp -an');
    echo '{"tablesonline":' .json_encode($cData).'}';          
   // echo '{"users":' .json_encode($cData).'}';          
          

}



?>

