<?php


function _getProduct($pdata)
{
    include ('../pdocon.php');
    $id = $pdata["id"];
    $company = $pdata["company"];
    
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProduct(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"products":' .json_encode($cData).'}';

}

function _getProductAllergens($pdata)
{
    include ('../pdocon.php');
    $id = $pdata["id"];
     
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getAllergens(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"allergens":' .json_encode($cData).'}';
}


function _countProdWarnings($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL countProdWarnings(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"warnings":' .json_encode($cData).'}';
    
}


function _countAuthSteps($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL countAuthSteps(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"warnings":' .json_encode($cData).'}';
    
}


function _countCustomerSteps($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL countCustomerSteps(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"warnings":' .json_encode($cData).'}';
    
}

function _countProdErrors($id)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL countProdErrors(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"errors":' .json_encode($cData).'}';
    
}


function _getProdStep($pData)
{
    include ('../pdocon.php');
    $pid = $pData["id"];
    $company = $pData["company"];
       
    $cData = array();
    $message = "Pending Product select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdSteps(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $pid, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Details";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    header('Content-Type: application/json');
    echo '{"prodsteps":' .json_encode($cData).'}';
}


function _getProdVersion($pid)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    
    $cData = array();
    $message = "Pending ProdVersion select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdVersions(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $pid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $cData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Details";
    }

    $response["Product"] = $cData;
    //header('Content-Type: application/json');
    echo '{"prodversions":' .json_encode($cData).'}';
    /*
     if (count($cData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($cData);
    else
          echo trim(json_encode($cData), '[]');
     */
}


function _getProdVersionBatches($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    $version = $cData["version"];
    
    $rData = array();
    $message = "Pending ProdVersion select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdVersionBatches(?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductVersionBatch"] = $rData;
    echo '{"prodversionbatches":' .json_encode($rData).'}';
    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */  

}




function _getProdBatches($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    // $company = $cData["company"];
    $rData = array();
    $message = "Pending ProdVersion select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdBatches(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        //$stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatch"] = $rData;
    echo '{"prodbatches":' .json_encode($rData).'}';
    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */  

}



function _getProdBatchSteps($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    $version = $cData["version"];
    $batch = $cData["batch"];
    
    $rData = array();
    $message = "Pending ProdBatchSteps select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdBatchSteps(?, ?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"prodbatchsteps":' .json_encode($rData).'}';

    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */
          

}


function _getProdBatchStepReport($cData)
{
    include ('../pdocon.php');
    $prodid = $cData['prodId'];
    $version = $cData['version'];
    $batch = $cData['batchId'];
    
    $rData = array();
    $message = "Pending ProdBatchSteps select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdBatchStepReport(?, ?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"prodbatchsteps":' .json_encode($rData).'}';

    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */
          

}


function _getProdBatchStepReportAuth($cData)
{
    include ('../pdocon.php');
    $prodid = $cData['prodId'];
    $version = $cData['version'];
    $batch = $cData['batchId'];
    
    $rData = array();
    $message = "Pending ProdBatchSteps select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdBatchStepAuth(?, ?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"prodbatchsteps":' .json_encode($rData).'}';

    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */
          

}


function _getProdBatchStepReportCustomer($cData)
{
    include ('../pdocon.php');
    $prodid = $cData['prodId'];
    $version = $cData['version'];
    $batch = $cData['batchId'];
    
    $rData = array();
    $message = "Pending ProdBatchSteps select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdBatchStepCustomer(?, ?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"prodbatchsteps":' .json_encode($rData).'}';

    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */
          

}


function _getProdBatchStepMeasures($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    $version = $cData["version"];
    $batch = $cData["batch"];
    $step = $cData["step"];
    
    $rData = array();
    $message = "Pending ProdBatchStepMeasures select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getBatchStepMeasures(?, ?, ?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->bindParam(4, $step, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"hazards":' .json_encode($rData).'}';

    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */
          

}



function _getProdBatchStepStorage($cData)
{
    include ('../pdocon.php');
    $company = $cData["company"];
      
    $rData = array();
    $message = "Pending ProdBatchStepStorage select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getBatchStepStorage(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $company, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStorage"] = $rData;
    echo '{"stores":' .json_encode($rData).'}';


          

}

function _getProdBatchStepIngredients($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    $version = $cData["version"];
    $batch = $cData["batch"];
    $step = $cData["step"];
    
    $rData = array();
    $message = "Pending ProdBatchStepIngredients select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getBatchStepIngredients(?, ?, ?, ?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $batch, PDO::PARAM_STR);
        $stmt->bindParam(4, $step, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"ingreds":' .json_encode($rData).'}';


          

}


function _getChainBatches($cData)
{
    include ('../pdocon.php');
    $chain = $cData["chain"];
      
    $rData = array();
    $message = "Pending ChainBatches select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getChainBatches(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $chain, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"chainbatches":' .json_encode($rData).'}';


          

}


function _getChainForBatch($cData)
{
    include ('../pdocon.php');
    $domain = $cData["domain"];
    $company = $cData["company"];
    $product = $cData["product"];
    $batch = $cData["batch"];
      
    $rData = array();
    $message = "Pending ChainBatches select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getChainForBatch(?,?,?,?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $domain, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->bindParam(3, $product, PDO::PARAM_STR);
        $stmt->bindParam(4, $batch, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"chainforbatch":' .json_encode($rData).'}';


          

}



function _getProdStepMeasures($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    $rData = array();
    $message = "Pending ProdStepMeasures select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL getProdStepMeasures(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["prodstepmeasures"] = $rData;
    echo '{"prodstepmeasures":' .json_encode($rData).'}';

    /*
    header('Content-Type: application/json');
    if (count($rData)>1)
          //echo '{"status":"success","data":' +json_encode($cData)+'}';
          echo json_encode($rData);
    else
          echo trim(json_encode($rData), '[]');
    */
          

}


function _getBatchSplitOptions($cData)
{
    include ('../pdocon.php');
    $prodid = $cData["prodid"];
    $rData = array();
    $message = "Pending ProdStepMeasures select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {
        $sql = 'CALL getBatchSplitOptions(?)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodid, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;
        $stmt->closeCursor();
        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["prodstepmeasures"] = $rData;
    echo '{"batchsplitoptions":' .json_encode($rData).'}';
          

}


function _insertProduct($cData)
{
    include ('../pdocon.php');
    $name = $cData['name'];
    $packaging = $cData['packaging'];
    $purpose = $cData['purpose'];
    $shelfLife = $cData['shelfLife'];
    $netWeight = $cData['netWeight'];
    $labeling = $cData['labeling'];
    $description = $cData['description'];
    $picture =$cData['picture'];
    $company =$cData['company'];
    $message = "Pending product select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL insertProduct(?,?,?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $name, PDO::PARAM_STR);
        $stmt->bindParam(2, $packaging, PDO::PARAM_STR);
        $stmt->bindParam(3, $purpose, PDO::PARAM_STR);
        $stmt->bindParam(4, $shelfLife, PDO::PARAM_STR);
        $stmt->bindParam(5, $netWeight, PDO::PARAM_STR);
        $stmt->bindParam(6, $labeling, PDO::PARAM_STR);
        $stmt->bindParam(7, $description, PDO::PARAM_STR);
        $stmt->bindParam(8, $picture, PDO::PARAM_STR);
        $stmt->bindParam(9, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Product ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
   echo '{"prodinsert":' .json_encode($actResponse).'}';
}


function _insertProdBatch($cData)
{
    include ('../pdocon.php');

    print_r($cData);
    $prodId = $cData['prodId'];
    $version = $cData['version'];
    $company = $cData['company'];
    echo $prodid, ",", $version;
    $message = "Pending product select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL insertProdBatch(?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $company, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        print_r($row);
        if ($row)
        {
            echo "what's happening";
            if ($row['Success']> 0)
            {
                $message = "Product ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _updateProdBatchStep($cData)
{
    include ('../pdocon.php');
    $sid = $cData['sid'];
    $prodId = $cData['prodId'];
    $version = $cData['version'];
    $batchId = $cData['batchId'];
    $stepId = $cData['stepId'];
    $reading = $cData['reading'];
    $comments = $cData['comments'];
    $checkby = $cData['checkby'];
    $result = $cData['result'];
    $checkedRisk = $cData['checkedRisk'];
    $message = "Pending product select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL updateProdBatchStep(?,?,?,?,?,?,?,?,?,?,@success,@updateTime)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $sid, PDO::PARAM_STR);
        $stmt->bindParam(2, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(3, $version, PDO::PARAM_STR);
        $stmt->bindParam(4, $batchId, PDO::PARAM_STR);
        $stmt->bindParam(5, $stepId, PDO::PARAM_STR);
        $stmt->bindParam(6, $reading, PDO::PARAM_STR);
        $stmt->bindParam(7, $comments, PDO::PARAM_STR);
        $stmt->bindParam(8, $checkby, PDO::PARAM_STR);
        $stmt->bindParam(9, $result, PDO::PARAM_STR);        
        $stmt->bindParam(10, $checkedRisk, PDO::PARAM_STR);        
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success, @updateTime AS updateTime")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        echo($sql);
        echo ($sid);
        print_r($cData);
        print_r($row);
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Product ".$row['Success']. " created Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



function _newBatchThisProduct($cData)
{
    include ('../pdocon.php');
    $domain = $cData["domain"];   
    $company = $cData["company"];   
    $prodid = $cData["prodid"];
    $version = $cData["version"];
    $batch = $cData["batch"];
    $step = $cData["step"];
    $qty = $cData["qty"];
    
    $rData = array();
    
    $message = "Pending NewBatchThisProduct select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL newBatchThisProduct(?, ?, ?, ?, ?, ?, ?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $domain, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->bindParam(3, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(4, $version, PDO::PARAM_STR);
        $stmt->bindParam(5, $batch, PDO::PARAM_STR);
        $stmt->bindParam(6, $step, PDO::PARAM_STR);
        $stmt->bindParam(7, $qty, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"newbatchthis":' .json_encode($rData).'}';


          

}



function _newBatchNewProduct($cData)
{
    include ('../pdocon.php');
    $domain = $cData["domain"];   
    $company = $cData["company"];   
    $prodid = $cData["prodid"];
    $newprodname = $cData["newprodname"];
    
    $version = $cData["version"];
    $batch = $cData["batch"];
    $step = $cData["step"];
    $qty = $cData["qty"];
    
    $rData = array();
    
    $message = "Pending NewBatchThisProduct select";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL newBatchNewProduct(?, ?, ?, ?, ?, ?, ?, ?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $domain, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->bindParam(3, $prodid, PDO::PARAM_STR);
        $stmt->bindParam(4, $newprodname, PDO::PARAM_STR);
        $stmt->bindParam(5, $version, PDO::PARAM_STR);
        $stmt->bindParam(6, $batch, PDO::PARAM_STR);
        $stmt->bindParam(7, $step, PDO::PARAM_STR);
        $stmt->bindParam(8, $qty, PDO::PARAM_STR);
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
           $rData[] = $row;

        $stmt->closeCursor();

        $response["status"] = "true";
        $response["message"] = "Product Versions";
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Product Versions";
    }

    $response["ProductBatchStep"] = $rData;
    echo '{"newbatchthis":' .json_encode($rData).'}';


          

}



function _updateProdBatchForTracking($cData)
{
    include ('../pdocon.php');
    $prodId = $cData['prodId'];
    $company = $cData['company'];
    $version = $cData['version'];
    $batchId = $cData['batchId'];
    $storedUrl = $cData['storedUrl'];
    $pdfHash = $cData['pdfHash'];
    $chainTxn = $cData['chainTxn'];
    $message = "Pending product select";
    $status = 0;    

    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL updateProdBatchForTracking(?,?,?,?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->bindParam(3, $version, PDO::PARAM_STR);
        $stmt->bindParam(4, $batchId, PDO::PARAM_STR);
        $stmt->bindParam(5, $storedUrl, PDO::PARAM_STR);
        $stmt->bindParam(6, $pdfHash, PDO::PARAM_STR);
        $stmt->bindParam(7, $chainTxn, PDO::PARAM_STR);
        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
    
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        echo($sql);
        print_r($cData);
        print_r($row);
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "batch ".$row['Success']. " updated Successfully.";
                $status = 1;
            }
        }

        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}




function _saveProdVersion($cData)
{
    include ('../pdocon.php');
    $prodId = $cData["prodId"];
    $comments = $cData["comments"];
    $sequence = $cData["sequence"];
    $company = $cData["company"];
    $message = "Pending version save";
    $status = 0;   
    $cancel =0; 
    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL saveProdVersion(?,?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $comments, PDO::PARAM_STR);
        $stmt->bindParam(3, $sequence, PDO::PARAM_STR);
        $stmt->bindParam(4, $company, PDO::PARAM_STR);

        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
             if ($row['Success']> 0)
            {
                $message = $row['message'];
                $status = 1;
                }
            }
        
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo trim(json_encode($actResponse), '[]');


}


function _setProdVersion($cData)
{
    include ('../pdocon.php');
    $prodId = $cData["prodId"];
    $version = $cData["version"];
    $company = $cData["company"];
    $message = "Pending version set";
    $status = 0;   
    $cancel =0; 
    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL setProdVersion(?,?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $version, PDO::PARAM_STR);
        $stmt->bindParam(3, $company, PDO::PARAM_STR);

        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
             if ($row['Success']> 0)
            {
                $message = $row['message'];
                $status = 1;
                }
            }
        
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo trim(json_encode($actResponse), '[]');


}


function _removeStep($cData)
{
     include ('../pdocon.php');
    $prodId = $cData["prodId"];
    $stepId = $cData["stepId"];
    $message = "Pending step remove";
    $status = 0;   
    $cancel =0; 
    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL deleteProdStep(?,?,@success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $prodId, PDO::PARAM_STR);
        $stmt->bindParam(2, $stepId, PDO::PARAM_STR);

        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success, @message as message, @cancel as cancel")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
             if ($row['Success']> 0)
            {
               if ($row['cancel']> 0)
               {
                  $cancel = $row['cancel'];
                  $message = "Update has been cancelled, as ".$row['message'];
                  $status = 0;
               }
              else{
                //$message = "Product updated Successfully.";
                $message = $row['message'];
                $status = 1;
                }
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message,
        'cancel'=>$cancel
    );
    header('Content-Type: application/json');
    echo trim(json_encode($actResponse), '[]');


}



function _setProdStep($cData)
{
     include ('../pdocon.php');
    $startseq = $cData["startseq"];
    $endseq = $cData["endseq"];
    $message = "Pending product select";
    $status = 0;   
    $cancel =0; 
    /////////////////////////////////////////////////////
    try
    {


        $sql = 'CALL updateProdSteps(?,?,@success, @message, @cancel)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $startseq, PDO::PARAM_STR);
        $stmt->bindParam(2, $endseq, PDO::PARAM_STR);

        $stmt->execute();
        
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success, @message as message, @cancel as cancel")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
             if ($row['Success']> 0)
            {
               if ($row['cancel']> 0)
               {
                  $cancel = $row['cancel'];
                  $message = "Update has been cancelled, as ".$row['message'];
                  $status = 0;
               }
              else{
                //$message = "Product updated Successfully.";
                $message = $row['message'];
                $status = 1;
                }
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message,
        'cancel'=>$cancel
    );
    header('Content-Type: application/json');
    echo trim(json_encode($actResponse), '[]');


}



function _deleteProduct($pdata)
{
    include ('../pdocon.php');
    //$id = $cData["id"];
    $id = $pdata["id"];
    $company = $pdata["company"];
    print_r($cData);
    $cData = array();
    $message = "Pending Product delete";
    $status = 0;    
    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL deleteProduct(?, ?, @success)';
        echo $sql;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $company, PDO::PARAM_STR);
        $stmt->execute();
           
        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Product ".$id. " removed Successfully.";
                $status = 1;
            }
        }
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Measure Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

 }




function _removeProdBatch($cData)
{
    include ('../pdocon.php');
    print('here');

    $prodId = $cData['prodId'];
    $batchId = $cData['batchId'];
    $company = $cData["company"];
    print_r($cData);
    $cData = array();
    $message = "Pending Product delete";
    $status = 0;    
    /////////////////////////////////////////////////////
     try
    {

        $sql = 'CALL deleteProdBatch(?,?,?, @success)';
        echo $sql ,$prodId, $batchId;
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(1, $prodId , PDO::PARAM_STR);
        $stmt->bindParam(2, $batchId, PDO::PARAM_STR);
        $stmt->bindParam(3, $company, PDO::PARAM_STR);
        $stmt->execute();
           
        $stmt->closeCursor();
         // execute the second query to get customer's level
         $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Product ".$id. " removed Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error retrieving Measure Details";
    }


    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);
   
 }




function _updateProduct($cData)
{
    include ('../pdocon.php');
    print_r($cData);
    $id = $cData->id;
    $name = $cData->name;
    $packaging = $cData->packaging;
    $purpose = $cData->purpose;
    $shelfLife = $cData->shelfLife;
    $netWeight = $cData->netWeight;
    $labeling = $cData->labeling;
    $description = $cData->description;
    $picture = $cData->picture;
    
    $message = "Pending Product update";
    $status = 0; 

    /////////////////////////////////////////////////////
    try
    {

        $sql = 'CALL updateProduct(?, ?,?,?, ?,?,?, ?,?, @success)';
        $pdo = new PDO($dsn, $dbuser, $dbpass, $params);
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $id, PDO::PARAM_STR);
        $stmt->bindParam(2, $name, PDO::PARAM_STR);
        $stmt->bindParam(3, $packaging, PDO::PARAM_STR);
        $stmt->bindParam(4, $purpose, PDO::PARAM_STR);
        $stmt->bindParam(5, $shelfLife, PDO::PARAM_STR);
        $stmt->bindParam(6, $netWeight, PDO::PARAM_STR);
        $stmt->bindParam(7, $labeling, PDO::PARAM_STR);
        $stmt->bindParam(8, $description, PDO::PARAM_STR);
        $stmt->bindParam(9, $picture, PDO::PARAM_STR);
        $stmt->execute();

        $stmt->closeCursor();
         // execute the second query to get customer's level
        $row = $pdo->query("SELECT @Success AS Success")
            ->fetch(PDO::FETCH_ASSOC);
        $newId = $row['Success']; 
        if ($row)
        {
            if ($row['Success']> 0)
            {
                $message = "Product ".$id. " updated Successfully.";
                $status = 1;
            }
        }
        
    }
    catch(PDOException $e)
    {
        echo ("Error occurred:" . $e->getMessage());
        $response["status"] = "False";
        $response["message"] = "Error creating customer";
    }

    $actResponse = array(
        'newId'=> $newId,
        'status' => $status,
        'status_message' => $message
    );
    header('Content-Type: application/json');
    echo json_encode($actResponse);

}



?>

